<?php
// disparo_geral.php - Versão final com envio de banners em álbum (Media Group)

// Configurações iniciais
set_time_limit(0); 
date_default_timezone_set('America/Sao_Paulo');
chdir(__DIR__);

// Inclui a biblioteca de funções e define constantes
require_once 'funcoes_api.php';
define('CONFIG_FILE', __DIR__ . '/telegram_config.json');

// --- 1. Validações e Carregamento de Configs ---
$gerador_id = $_GET['gerador'] ?? ($argv[1] ?? null); 
if (is_null($gerador_id) || !is_numeric($gerador_id) || $gerador_id < 1) {
    die('ERRO: É obrigatório especificar o gerador na URL ou como argumento. Exemplo: ?gerador=1');
}
$nome_gerador = ($gerador_id == 1) ? 'gerar_fut' : 'gerar_fut_' . $gerador_id;

$config = json_decode(file_get_contents(CONFIG_FILE), true);
$token = $config['token'] ?? null;
$chat_id = $config['chat_id'] ?? null;
if (!$token || !$chat_id) { die("ERRO: Token ou Chat ID não configurados no telegram_config.json."); }

header('Content-Type: text/plain; charset=utf-8');
echo "--- Iniciando Disparo Geral para o gerador [$nome_gerador] em: " . date('d/m/Y H:i:s') . " ---\n\n";

// --- 2. Busca e Agrupa os Jogos ---
$chave = getChaveRemota();
$url_jogos = $chave ? descriptografarURL('SVI0Sjh1MTJuRkw1bmFyeFdPb3cwOXA2TFo3RWlSQUxLbkczaGE4MXBiMWhENEpOWkhkSFZoeURaWFVDM1lTZzo6RNBu5BBhzmFRkTPPSikeJg==', $chave) : null;
$jogos_de_hoje = [];
if ($url_jogos) {
    $json_content = @file_get_contents($url_jogos);
    if ($json_content) {
        $todos_jogos = json_decode($json_content, true);
        if (is_array($todos_jogos)) {
            foreach ($todos_jogos as $jogo) {
                if (isset($jogo['data_jogo']) && $jogo['data_jogo'] === 'hoje') {
                    $jogos_de_hoje[] = $jogo;
                }
            }
        }
    }
}
$gruposDeJogos = array_chunk($jogos_de_hoje, 5);
echo "Total de jogos encontrados para hoje: " . count($jogos_de_hoje) . "\n";
echo "Total de banners a serem enviados: " . count($gruposDeJogos) . "\n\n";

// --- 3. Geração e Salvamento de TODOS os banners primeiro ---
if (empty($gruposDeJogos)) {
    echo "Processo finalizado. Nenhum banner para enviar.\n";
    exit;
}

echo "Iniciando a geração e salvamento de todos os " . count($gruposDeJogos) . " banners...\n";

$arquivos_para_enviar = [];
$media_array = [];

foreach ($gruposDeJogos as $grupo_id => $dados_grupo) {
    echo "Processando Grupo $grupo_id...\n";

    $dominio = $_SERVER['HTTP_HOST'];
    $url_imagem_gerador = "https://{$dominio}/admin/{$nome_gerador}.php?grupo={$grupo_id}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_imagem_gerador);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 180);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8',
        'Accept-Language: pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7',
        'Referer: https://{$dominio}/'
    ]);

    $dados_imagem = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200 && !empty($dados_imagem) && strlen($dados_imagem) > 1024) {
        // Nome único por gerador e grupo
        $nome_anexo = 'banner_' . $gerador_id . '_' . $grupo_id;
        $caminho_temporario = __DIR__ . '/temp_' . $nome_anexo . '.jpg';

        file_put_contents($caminho_temporario, $dados_imagem);

        $arquivos_para_enviar[$nome_anexo] = $caminho_temporario;

        $media_item = ['type' => 'photo', 'media' => 'attach://' . $nome_anexo];
        if ($grupo_id === 0) {
            $media_item['caption'] = "Jogos de Hoje - " . date('d/m/Y');
        }
        $media_array[] = $media_item;

        echo "  - Imagem do Grupo $grupo_id gerada com sucesso.\n";
    } else {
        echo "  - ERRO: Falha ao gerar a imagem do Grupo $grupo_id. Banner ignorado.\n";
    }
    sleep(2);
}

// --- 4. Envio ÚNICO do álbum para o Telegram ---
if (!empty($arquivos_para_enviar)) {
    echo "\nPreparando para enviar o álbum com " . count($arquivos_para_enviar) . " banners para o Telegram...\n";

    $url_api = "https://api.telegram.org/bot$token/sendMediaGroup";

    $post_fields = [
        'chat_id' => $chat_id,
        'media'   => json_encode($media_array)
    ];

    foreach ($arquivos_para_enviar as $key => $path) {
        $post_fields[$key] = new CURLFile(realpath($path));
    }

    $ch_telegram = curl_init();
    curl_setopt($ch_telegram, CURLOPT_HTTPHEADER, ["Content-Type:multipart/form-data"]);
    curl_setopt($ch_telegram, CURLOPT_URL, $url_api);
    curl_setopt($ch_telegram, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_telegram, CURLOPT_POSTFIELDS, $post_fields);
    $result = curl_exec($ch_telegram);
    curl_close($ch_telegram);

    $response = json_decode($result, true);
    if ($response && $response['ok']) {
        echo "SUCESSO: Álbum enviado para o Telegram!\n";
    } else {
        $errorMessage = $response['description'] ?? 'Erro desconhecido.';
        echo "ERRO ao enviar o álbum: " . htmlspecialchars($errorMessage) . "\n";
    }
} else {
    echo "\nNenhum banner foi gerado com sucesso para o envio.\n";
}

// --- 5. Limpeza Final ---
echo "Iniciando limpeza de arquivos temporários...\n";
foreach ($arquivos_para_enviar as $path) {
    if (file_exists($path)) {
        unlink($path);
    }
}
echo "Limpeza concluída.\n";

echo "\n--- Processo Finalizado em: " . date('d/m/Y H:i:s') . " ---\n";
?>
