<?php
session_start();
$pdo = new PDO("sqlite:api/.fzstoredev.db");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$success = false;
$erro = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);

    $stmt = $pdo->prepare("SELECT password FROM usuarios WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user["password"])) {
        $_SESSION["usuario"] = $username;
        $success = true;
    } else {
        $erro = "Usuário ou senha inválidos!";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PAINEL</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        :root {
            --md-sys-color-primary: #6750A4;
            --md-sys-color-on-primary: #FFFFFF;
            --md-sys-color-primary-container: #EADDFF;
            --md-sys-color-on-primary-container: #21005D;
            --md-sys-color-secondary: #625B71;
            --md-sys-color-on-secondary: #FFFFFF;
            --md-sys-color-secondary-container: #E8DEF8;
            --md-sys-color-on-secondary-container: #1D192B;
            --md-sys-color-tertiary: #7D5260;
            --md-sys-color-on-tertiary: #FFFFFF;
            --md-sys-color-tertiary-container: #FFD8E4;
            --md-sys-color-on-tertiary-container: #31111D;
            --md-sys-color-error: #BA1A1A;
            --md-sys-color-on-error: #FFFFFF;
            --md-sys-color-error-container: #FFDAD6;
            --md-sys-color-on-error-container: #410002;
            --md-sys-color-background: #FFFBFE;
            --md-sys-color-on-background: #1C1B1F;
            --md-sys-color-surface: #FFFBFE;
            --md-sys-color-on-surface: #1C1B1F;
            --md-sys-color-surface-variant: #E7E0EC;
            --md-sys-color-on-surface-variant: #49454F;
            --md-sys-color-outline: #79747E;
            --md-sys-color-shadow: #000000;
            --md-sys-color-inverse-surface: #313033;
            --md-sys-color-inverse-on-surface: #F4EFF4;
            --md-sys-color-inverse-primary: #D0BCFF;
            --md-sys-color-surface-tint: #6750A4;
        }

        body {
            margin: 0;
            padding: 0;
            background: linear-gradient(145deg, #1A1C20, #2C2F33, #3E4247);
            color: #E8DEF8;
            font-family: 'Roboto', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .login-container {
            background-color: #313033;
            padding: 40px 30px;
            border-radius: 28px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2), 0 8px 24px rgba(0, 0, 0, 0.3);
            width: 340px;
            text-align: center;
        }

        .login-container img.logo {
            max-width: 130px;
            margin-bottom: 25px;
            filter: drop-shadow(0 2px 5px rgba(0, 0, 0, 0.3));
        }

        .login-container h2 {
            margin-bottom: 30px;
            color: var(--md-sys-color-primary-container);
            font-size: 2rem;
            letter-spacing: 0.01em;
            font-weight: 500;
        }

        .login-container input {
            width: calc(100% - 30px);
            padding: 14px 15px;
            margin-bottom: 20px;
            border: 1px solid #8884aa;
            border-radius: 12px;
            background-color: #2A2D32;
            color: #FFFFFF;
            transition: border-color 0.3s, box-shadow 0.3s;
            font-size: 1rem;
            box-sizing: border-box;
        }

        .login-container input::placeholder {
            color: #CCCCCC;
            opacity: 0.7;
        }

        .login-container input:focus {
            border-color: #A892E0;
            outline: none;
            box-shadow: 0 0 0 3px rgba(168, 146, 224, 0.3);
            background-color: #33363C;
        }

        .login-container button {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 20px;
            color: var(--md-sys-color-on-primary);
            background: var(--md-sys-color-primary);
            font-weight: 500;
            font-size: 1.1rem;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1), 0 4px 8px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            transition: background-color 0.3s, box-shadow 0.3s, transform 0.2s;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
        }

        .login-container button:hover {
            background-color: #7A66C0;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2),
                        0 6px 12px rgba(0, 0, 0, 0.3);
        }

        .login-container button:active {
            background-color: #55418F;
            transform: translateY(0);
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        .error-message {
            margin-top: 20px;
            background-color: var(--md-sys-color-error-container);
            padding: 12px;
            border-radius: 8px;
            color: var(--md-sys-color-on-error-container);
            font-weight: 500;
            font-size: 0.95rem;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .register-link-button,
        .register-outlined-button {
            display: flex;
            margin: 0 auto;
            padding: 14px;
            margin-top: 20px;
            border: 1px solid var(--md-sys-color-primary);
            border-radius: 20px;
            background-color: var(--md-sys-color-background);
            color: var(--md-sys-color-primary);
            text-decoration: none;
            font-weight: 500;
            font-size: 1.1rem;
            gap: 8px;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s, border-color 0.3s, box-shadow 0.3s, transform 0.2s;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.08);
            align-items: center;
            justify-content: center;
            max-width: 280px;
        }

        .register-link-button:hover,
        .register-outlined-button:hover {
            background-color: var(--md-sys-color-primary-container);
            color: var(--md-sys-color-on-primary-container);
            border-color: var(--md-sys-color-primary);
            transform: translateY(-1px);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.15);
        }

        .register-link-button:active,
        .register-outlined-button:active {
            background-color: var(--md-sys-color-secondary-container);
            color: var(--md-sys-color-on-secondary-container);
            transform: translateY(0);
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.08);
        }
    </style>
</head>
<body>
<div class="login-container">
    <img src="https://jogos.wctv.top/costaa/admin/img/logo.png" alt="Logo HL" class="logo">
    <h2><i class="fas fa-user-lock"></i> PAINEL</h2>
    <form method="POST">
        <label for="username" style="position: absolute; left: -9999px;">Usuário</label>
        <input type="text" name="username" id="username" placeholder="Usuário" required autocomplete="username">
        <label for="password" style="position: absolute; left: -9999px;">Senha</label>
        <input type="password" name="password" id="password" placeholder="Senha" required autocomplete="current-password">
        <button type="submit"><i class="fas fa-sign-in-alt"></i> Entrar</button>
    </form>
    <?php if (!empty($erro)): ?>
        <div class="error-message"><?= htmlspecialchars($erro, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>
   
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    <?php if ($success): ?>
    Swal.fire({
        icon: 'success',
        title: 'Login Realizado!',
        text: 'Você será redirecionado em breve.',
        timer: 2000,
        timerProgressBar: true,
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => { Swal.showLoading(); },
        willClose: () => { window.location.href = 'index.php'; }
    });
    <?php endif; ?>

    <?php if (!empty($erro)): ?>
    Swal.fire({
        icon: 'error',
        title: 'Erro de Login!',
        text: '<?= htmlspecialchars($erro, ENT_QUOTES, 'UTF-8') ?>',
        confirmButtonText: 'Tentar Novamente'
    });
    <?php endif; ?>
</script>
</body>
</html>
